



/******************************************************************************************
 *                                                                                        *
 * Ex1.     :   Read BCD Code(4bit) From Touch PAD Key 4x4 Out To RS232                   *
 *                        (Format:Press Single Key only)                                  *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU      : ATMEGA168(ET-BASE AVR EASY MEGA168)                                  *
 *                 : X-TAL : 16 MHz                                                       *
 *                                                                                        *
 * Compiler Editor : Arduino 1.0.4                                                        *
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                 *
 * Last Update     : 12/September/2014                                                    *
 *                                                                                        *
 * Port Interface  :  -- MCU-AT MEGA168--                   -- Key Touch PAD 4x4 --       *  
 *                                                                                        *
 *       Uart0     : D0 = TXDO          Connect                Tx of Board Touch Key      *  
 *                   D1 = RXD0          Connect                Rx of Board Touch Key      *
 *                   Baud Rate = 9600  at Clock 16 MHz                                    *
 *                                                                                        *
 *      BCD Port  :  D8(Input)          Connect                 BCD Colum 1               * 
 *                   D9(Input)          Connect                 BCD Colum 2               *
 *                   D10(Input)         Connect                 BCD Colum 4               *
 *                   D11(Input)         Connect                 BCD Colum 8               *
 *                   D12(Input)         Connect                 T#/R Ststus 1Key          *
 *                   D13(Input)         Not Use                 SHIF# Statu 2Key          *
 *                                                                                        *
 *   Operation  : When Touch Key will Show BCD Key Code(Hex)on Hyperterminal              *
 *                                                                                        *
 ******************************************************************************************/

//----------- Defind BCD Port D8..D13 ---------------- 

#define BCD1           8      //D8
#define BCD2           9      //D9
#define BCD4          10      //D10   
#define BCD8          11      //D11
#define TR            12      //D12
#define Shif          13      //D13

//****************************** Sub Program ******************************

//---------------------- Check Touch /Release Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
    tr = digitalRead(TR)         ;   //Read Status Key
   
    if(tr != 1)                      //Check Statue Key
      return (0)                ;    //Touch Key Return 0 (D12=0)
    else
       return (1)               ;    //Release Key Return 1   (D12=1)
 }


//---------- Read BCD Key Code -----------------

 int RD_KeyCode(void) 
  {
    int KeyCode=0                 ;
   
     KeyCode  = digitalRead(BCD8)           ;   //Read BCD(8) Code bit D11   
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD4)           ;   //Read BCD(4) Code bit D10 
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD2)           ;   //Read BCD(2) Code bit D9   
     KeyCode  = KeyCode << 1                ;
     KeyCode |= digitalRead(BCD1)           ;   //Read BCD(1) Code bit D8   
     KeyCode &= 0x0F                        ;        
    return (KeyCode)                        ;
  }



/*##########################################################################
  ##                                                                      ##
  ##                               SETUP                                  ##
  ##                                                                      ##
  ##########################################################################*/



void setup() 
{ 
 //------------Initial Port D8..D13 =Input for Read Key Code --------------- 
  
    pinMode(BCD1,INPUT_PULLUP)           ; //Set Status pin D8  = Input Pull-Up 
    pinMode(BCD2,INPUT_PULLUP)           ; //Set Status pin D9  = Input Pull-Up  
    pinMode(BCD4,INPUT_PULLUP)           ; //Set Status pin D10 = Input Pull-Up  
    pinMode(BCD8,INPUT_PULLUP)           ; //Set Status pin D11 = Input Pull-Up  
    pinMode(TR,INPUT_PULLUP)             ; //Set Status pin D12 = Input Pull-Up  
    pinMode(Shif,INPUT_PULLUP)           ; //Set Status pin D13 = Input Pull-Up 
    
   
 //--------------------- Initial UART0 -(D0=Tx ,D1=Rx)----------------------
 
    Serial.begin(9600)             ;  //Set Board Rate Uart0 =9600
  
}



/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 #######################################################################*/
 

void loop() 
{ 
   unsigned int key ;
   
   Serial.print("*************************************************************************\r\n");    
   Serial.print("**          Ex1.TEST READ KEY CODE BCD Touch PAD4x4                    **\r\n");        
   Serial.print("*************************************************************************\r\n"); 
  
  while(1)
  {

      if(!Check_TR())                            //Step1: Check  pressed key (Check_TR()=0:press,1:release) 
       {
         key = RD_KeyCode()                   ;  //Step2: Read Key Code

        //---------- Step3:Program Respond press key for user ------------
       
         Serial.print("Key_Code BCD = 0x0")   ;   //Print Key Code Out RS232
         Serial.print(key,HEX);
         Serial.print("\n\r")                 ;

        while(!Check_TR()){;}                 ; //Wait Release Key (=1 exit loop)
       }          
  }  
}








